/**
 * Extension configuration
 */
export const config = {
  // API base URL - dedicated extension subdomain
  // ext.sortula.ru proxies to backend /v1/extension/* endpoints
  API_URL: 'https://ext.sortula.ru/api',

  // Token refresh threshold (refresh when less than 5 minutes left)
  TOKEN_REFRESH_THRESHOLD: 5 * 60 * 1000,

  // Default notification duration (ms)
  NOTIFICATION_DURATION: 3000,

  // Offline queue sync interval (ms)
  SYNC_INTERVAL: 30 * 1000,

  // Maximum items in offline queue
  MAX_QUEUE_SIZE: 100,
};

export default config;
